#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.schema import Choice

from pyams_content.component.paragraph.interfaces import IBaseParagraph


__docformat__ = 'restructuredtext'

from pyams_content import _


#
# Associations paragraph
#

ASSOCIATION_PARAGRAPH_TYPE = 'Associations'
ASSOCIATION_PARAGRAPH_NAME = _("Associations")
ASSOCIATION_PARAGRAPH_RENDERERS = 'PyAMS.associations.renderers'


class IAssociationParagraph(IBaseParagraph):
    """Associations paragraph interface"""

    renderer = Choice(title=_("Associations template"),
                      description=_("Presentation template used for associations"),
                      vocabulary=ASSOCIATION_PARAGRAPH_RENDERERS,
                      default='default')
