#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_skin.interfaces.viewlet import IMenuItem

# import packages
from zope.interface import Interface, Attribute


#
# Custom menus interfaces
#

class ISiteTreeMenu(IMenuItem):
    """Site tree menu marker interface"""


class ISiteTreeTable(Interface):
    """Site tree table view marker interface"""


class IDashboardMenu(IMenuItem):
    """Dashboard menu"""


class IMyDashboardMenu(IMenuItem):
    """My contents dashboard menu"""


class IAllContentsMenu(IMenuItem):
    """Dashboard menu for all contents"""


class ISummaryMenu(IMenuItem):
    """Summary menu"""


class IUserAddingsMenuLabel(Interface):
    """Shared tool adding menu label"""

    label = Attribute("Addings menu label")
