#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from colander import DateTime, Integer, MappingSchema, OneOf, SchemaNode, String, drop

from pyams_content.workflow.interfaces import STATES_IDS


class WorkflowPublicationInfo(MappingSchema):
    """Workflow publication info schema"""

    state = SchemaNode(String(),
                       description="Workflow publication state",
                       validator=OneOf(STATES_IDS),
                       missing=drop)
    version = SchemaNode(Integer(),
                         description="Workflow version number",
                         missing=drop)
    publication_date = SchemaNode(DateTime(),
                                  description="First publication datetime in iso8601 format, including timezone",
                                  missing=drop)
    expiration_date = SchemaNode(DateTime(),
                                 description="Publication expiration datetime in iso8601 format, including timezone",
                                 missing=drop)
