#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form import field
from zope.interface import Interface

from pyams_content.interfaces import CREATE_CONTENT_PERMISSION, MANAGE_CONTENT_PERMISSION
from pyams_content.shared.common.zmi import SharedContentAJAXAddForm
from pyams_content.shared.common.zmi.types import TypedSharedContentAddForm, TypedSharedContentPropertiesEditForm
from pyams_content.shared.topic.interfaces import ITopicManager, IWfTopic
from pyams_form.form import ajax_config
from pyams_i18n.interfaces import II18n
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IContentTitle
from pyams_skin.interfaces.viewlet import IMenuHeader, IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.adapter import ContextRequestAdapter, ContextRequestViewAdapter, adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.interfaces.menu import IContentManagementMenu
from pyams_zmi.layer import IAdminLayer

from pyams_content import _


@adapter_config(context=(IWfTopic, IContentManagementMenu), provides=IMenuHeader)
class TopicContentMenuHeader(ContextRequestAdapter):
    """Topic content menu header adapter"""

    header = _("This topic")


@adapter_config(context=(IWfTopic, IPyAMSLayer, Interface), provides=IContentTitle)
class TopicTitleAdapter(ContextRequestViewAdapter):
    """Topic title adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("Topic « {title} »")).format(
            title=II18n(self.context).query_attribute('title', request=self.request))


@viewlet_config(name='add-shared-content.action', context=ITopicManager, layer=IAdminLayer, view=Interface,
                manager=IWidgetTitleViewletManager, permission=CREATE_CONTENT_PERMISSION, weight=1)
class TopicAddAction(ToolbarAction):
    """Topic adding action"""

    label = _("Add topic")
    label_css_class = 'fa fa-fw fa-plus'
    url = 'add-shared-content.html'
    modal_target = True


@pagelet_config(name='add-shared-content.html', context=ITopicManager, layer=IPyAMSLayer,
                permission=CREATE_CONTENT_PERMISSION)
@ajax_config(name='add-shared-content.json', context=ITopicManager, layer=IPyAMSLayer,
             permission=CREATE_CONTENT_PERMISSION, base=SharedContentAJAXAddForm)
class TopicAddForm(TypedSharedContentAddForm):
    """Topic add form"""

    legend = _("Add topic")

    fields = field.Fields(IWfTopic).select('title', 'data_type', 'notepad')


@pagelet_config(name='properties.html', context=IWfTopic, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='properties.json', context=IWfTopic, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
class TopicPropertiesEditForm(TypedSharedContentPropertiesEditForm):
    """Topic properties edit form"""

    interface = IWfTopic
