#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.illustration.interfaces import IIllustrationTarget, \
    ILinkIllustrationTarget
from pyams_content.component.paragraph.interfaces import IParagraphContainerTarget
from pyams_content.component.theme.interfaces import ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review.interfaces import IReviewTarget
from pyams_content.shared.common import SharedContent, WfSharedContent, register_content_type
from pyams_content.shared.common.interfaces import IWfSharedContentFactory
from pyams_content.shared.common.types import WfTypedSharedContentMixin
from pyams_content.shared.topic.interfaces import ITopic, IWfTopic, IWfTopicFactory, \
    TOPIC_CONTENT_NAME, TOPIC_CONTENT_TYPE
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'


@implementer(IWfTopic, IIllustrationTarget, ILinkIllustrationTarget, IParagraphContainerTarget,
             ITagsTarget, IThemesTarget, IPreviewTarget, IReviewTarget)
class WfTopic(WfSharedContent, WfTypedSharedContentMixin):
    """Base topic"""

    content_type = TOPIC_CONTENT_TYPE
    content_name = TOPIC_CONTENT_NAME

    references = FieldProperty(IWfTopic['references'])
    data_type = FieldProperty(IWfTopic['data_type'])

register_content_type(WfTopic)


@provider(IWfTopicFactory)
@implementer(ITopic)
class Topic(SharedContent):
    """Workflow managed topic class"""


@adapter_config(context=IWfTopicFactory, provides=IWfSharedContentFactory)
def topic_content_factory(context):
    return WfTopic
