#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.illustration.interfaces import IIllustrationTarget, ILinkIllustrationTarget
from pyams_content.component.paragraph.interfaces import IParagraphContainerTarget
from pyams_content.component.theme.interfaces import ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review.interfaces import IReviewTarget
from pyams_content.shared.common.interfaces import IWfSharedContentFactory
from pyams_content.shared.common import SharedContent, WfSharedContent, register_content_type
from pyams_content.shared.common.types import WfTypedSharedContentMixin
from pyams_content.shared.site.interfaces import ISiteElementNavigation, ISiteTopic, IWfSiteTopic, \
    IWfSiteTopicFactory, SITE_TOPIC_CONTENT_NAME, SITE_TOPIC_CONTENT_TYPE
from pyams_utils.adapter import adapter_config
from pyams_workflow.interfaces import IWorkflow, IWorkflowState, IWorkflowVersions


__docformat__ = 'restructuredtext'


@implementer(IWfSiteTopic, IIllustrationTarget, ILinkIllustrationTarget, IParagraphContainerTarget,
             ITagsTarget, IThemesTarget, IPreviewTarget, IReviewTarget)
class WfSiteTopic(WfSharedContent, WfTypedSharedContentMixin):
    """Base site topic"""

    content_type = SITE_TOPIC_CONTENT_TYPE
    content_name = SITE_TOPIC_CONTENT_NAME

    references = FieldProperty(IWfSiteTopic['references'])
    data_type = FieldProperty(IWfSiteTopic['data_type'])

register_content_type(WfSiteTopic)


@provider(IWfSiteTopicFactory)
@implementer(ISiteTopic)
class SiteTopic(SharedContent):
    """Workflow managed topic class"""

    content_name = SITE_TOPIC_CONTENT_NAME

    def is_deletable(self):
        workflow = IWorkflow(self)
        for version in IWorkflowVersions(self).get_versions():
            if IWorkflowState(version).state != workflow.initial_state:
                return False
        return True


@adapter_config(context=IWfSiteTopicFactory, provides=IWfSharedContentFactory)
def site_topic_content_factory(context):
    return WfSiteTopic
