#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form.browser.object import ObjectWidget
from z3c.form.interfaces import IFieldWidget, IObjectFactory
from z3c.form.object import getIfName
from z3c.form.widget import FieldWidget
from zope.interface import Interface, alsoProvides, implementer_only

from pyams_content.shared.resource import IAgeRange
from pyams_content.shared.resource.schema import AgeRange, IAgeRangeField
from pyams_content.shared.resource.zmi.interfaces import IAgeRangeWidget
from pyams_form.interfaces import IForm, IFormLayer
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces.data import IObjectData


@adapter_config(name=getIfName(IAgeRange),
                context=(Interface, IFormLayer, IForm, IAgeRangeWidget), provides=IObjectFactory)
class AgeRangeObjectFactory(object):
    """Age range object factory"""

    def __init__(self, context, request, form, widget):
        self.context = context
        self.request = request
        self.form = form
        self.widget = widget

    def __call__(self, data):
        return AgeRange()


@implementer_only(IAgeRangeWidget)
class AgeRangeWidget(ObjectWidget):
    """Age range widget"""

    def updateWidgets(self, setErrors=True):
        super(AgeRangeWidget, self).updateWidgets(setErrors)
        widgets = self.widgets
        for name in ('min_value', 'max_value'):
            widget = widgets[name]
            widget.label_css_class = 'control-label col-md-2'
            widget.input_css_class = 'col-md-1'
            widget.object_data = {
                'input-mask': '9{1,3}'
            }
            alsoProvides(widget, IObjectData)


@adapter_config(context=(IAgeRangeField, IFormLayer), provides=IFieldWidget)
def AgeRangeFieldWidget(field, request):
    """Age range field widget factory"""
    return FieldWidget(field, AgeRangeWidget(request))
