#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface, implementer
from zope.schema import Int, Object
from zope.schema.fieldproperty import FieldProperty
from zope.schema.interfaces import IObject

from pyams_content import _


class IAgeRange(Interface):
    """Age range attribute interface"""

    min_value = Int(title=_("Minimum age"),
                    required=False)

    max_value = Int(title=_("Maximum age"),
                    required=False)


@implementer(IAgeRange)
class AgeRange(object):
    """Age range attribute object"""

    min_value = FieldProperty(IAgeRange['min_value'])
    max_value = FieldProperty(IAgeRange['max_value'])

    def __bool__(self):
        return bool(self.min_value or self.max_value)


class IAgeRangeField(IObject):
    """Age range schema field interface"""


@implementer(IAgeRangeField)
class AgeRangeField(Object):
    """Age range schema field class"""

    def __init__(self, **kwargs):
        if 'schema' in kwargs:
            del kwargs['schema']
        super(AgeRangeField, self).__init__(IAgeRange, **kwargs)
