#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyramid.events import subscriber
from zope.component.interfaces import ISite
from zope.interface import implementer
from zope.lifecycleevent import IObjectAddedEvent
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.paragraph import IParagraphFactorySettings
from pyams_content.component.theme import IThemesManagerTarget
from pyams_content.reference.pictograms.interfaces import IPictogramManagerTarget
from pyams_content.shared.common.interfaces import ISharedContentFactory
from pyams_content.shared.common.manager import SharedTool
from pyams_content.shared.common.types import TypedSharedToolMixin
from pyams_content.shared.resource import IResourceInfo, RESOURCE_CONTENT_TYPE, Resource
from pyams_content.shared.resource.interfaces import IResourceManager, IResourceManagerFactory
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import utility_config
from pyams_utils.traversing import get_parent


__docformat__ = 'restructuredtext'


@implementer(IResourceManager, IParagraphFactorySettings, IPictogramManagerTarget,
             IThemesManagerTarget)
class ResourceManager(SharedTool, TypedSharedToolMixin):
    """Resource manager class"""

    shared_content_type = RESOURCE_CONTENT_TYPE

    shared_content_types_fields = IResourceInfo

    allowed_paragraphs = FieldProperty(IParagraphFactorySettings['allowed_paragraphs'])
    auto_created_paragraphs = FieldProperty(IParagraphFactorySettings['auto_created_paragraphs'])


@utility_config(provides=IResourceManagerFactory)
class ResourceManagerFactory(object):
    """Default resource manager factory"""

    def __new__(cls):
        return ResourceManager


@adapter_config(context=IResourceManager, provides=ISharedContentFactory)
def resource_manager_content_factory(context):
    return Resource


@subscriber(IObjectAddedEvent, context_selector=IResourceManager)
def handle_added_resource_manager(event):
    """Register resource manager when added"""
    site = get_parent(event.newParent, ISite)
    registry = site.getSiteManager()
    if registry is not None:
        registry.registerUtility(event.object, IResourceManager)
