#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from persistent import Persistent
from zope.container.contained import Contained
from zope.interface import implementer, provider
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.illustration.interfaces import IIllustrationTarget, \
    ILinkIllustrationTarget
from pyams_content.component.paragraph.interfaces import IParagraphContainerTarget
from pyams_content.component.theme.interfaces import ICollectionsTarget, ITagsTarget, IThemesTarget
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.review.interfaces import IReviewTarget
from pyams_content.shared.common import SharedContent, WfSharedContent, register_content_type
from pyams_content.shared.common.interfaces import IWfSharedContentFactory
from pyams_content.shared.common.types import WfTypedSharedContentMixin
from pyams_content.shared.resource.interfaces import IResource, IResourceInfo, IWfResource, \
    IWfResourceFactory, RESOURCE_CONTENT_NAME, RESOURCE_CONTENT_TYPE, RESOURCE_INFO_ANNOTATIONS_KEY
from pyams_content.shared.resource.schema import IAgeRange
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config


__docformat__ = 'restructuredtext'


@implementer(IWfResource, IIllustrationTarget, ILinkIllustrationTarget, IParagraphContainerTarget,
             ITagsTarget, ICollectionsTarget, IThemesTarget, IPreviewTarget, IReviewTarget)
class WfResource(WfSharedContent, WfTypedSharedContentMixin):
    """Resource class"""

    content_type = RESOURCE_CONTENT_TYPE
    content_name = RESOURCE_CONTENT_NAME

    references = FieldProperty(IWfResource['references'])

register_content_type(WfResource)


@factory_config(IResourceInfo)
class ResourceInfo(Persistent, Contained):
    """Resource persistent information"""

    original_country = FieldProperty(IResourceInfo['original_country'])
    original_title = FieldProperty(IResourceInfo['original_title'])
    author = FieldProperty(IResourceInfo['author'])
    translator = FieldProperty(IResourceInfo['translator'])
    illustrator = FieldProperty(IResourceInfo['illustrator'])
    drawer = FieldProperty(IResourceInfo['drawer'])
    colourist = FieldProperty(IResourceInfo['colourist'])
    lettering = FieldProperty(IResourceInfo['lettering'])
    producer = FieldProperty(IResourceInfo['producer'])
    director = FieldProperty(IResourceInfo['director'])
    actors = FieldProperty(IResourceInfo['actors'])
    editor = FieldProperty(IResourceInfo['editor'])
    collection = FieldProperty(IResourceInfo['collection'])
    series = FieldProperty(IResourceInfo['series'])
    volume = FieldProperty(IResourceInfo['volume'])
    format = FieldProperty(IResourceInfo['format'])
    nb_pages = FieldProperty(IResourceInfo['nb_pages'])
    duration = FieldProperty(IResourceInfo['duration'])
    age_range = FieldProperty(IResourceInfo['age_range'])
    release_year = FieldProperty(IResourceInfo['release_year'])
    awards = FieldProperty(IResourceInfo['awards'])
    editor_reference = FieldProperty(IResourceInfo['editor_reference'])
    isbn_number = FieldProperty(IResourceInfo['isbn_number'])
    price = FieldProperty(IResourceInfo['price'])
    source_url = FieldProperty(IResourceInfo['source_url'])
    summary = FieldProperty(IResourceInfo['summary'])
    synopsis = FieldProperty(IResourceInfo['synopsis'])
    publisher_words = FieldProperty(IResourceInfo['publisher_words'])


@adapter_config(context=IWfResource, provides=IResourceInfo)
def resource_info_factory(context):
    """Resource info factory"""
    return get_annotation_adapter(context, RESOURCE_INFO_ANNOTATIONS_KEY, IResourceInfo,
                                  name='++info++')


@provider(IWfResourceFactory)
@implementer(IResource)
class Resource(SharedContent):
    """Workflow managed resource"""


@adapter_config(context=IWfResourceFactory, provides=IWfSharedContentFactory)
def resource_content_factory(context):
    return WfResource
