#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_content import _
from pyams_content.shared.common.interfaces import ISharedContent, ISharedToolPortalContext, \
    IWfSharedContentPortalContext
from pyams_sequence.interfaces import IInternalReferencesList


NEWS_CONTENT_TYPE = 'news'
NEWS_CONTENT_NAME = _("News topic")


class INewsManager(ISharedToolPortalContext):
    """News manager interface"""


class INewsManagerFactory(Interface):
    """News manager factory interface"""


class IWfNewsEvent(IWfSharedContentPortalContext, IInternalReferencesList):
    """News event interface"""


class IWfNewsEventFactory(Interface):
    """News event factory interface"""


class INewsEvent(ISharedContent):
    """Workflow managed news event interface"""
