#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.view import view_config
from zope.interface import Interface

from pyams_content.interfaces import CREATE_CONTENT_PERMISSION
from pyams_content.shared.common.zmi import SharedContentAJAXAddForm, SharedContentAddForm
from pyams_content.shared.logo import IWfLogo
from pyams_content.shared.logo.interfaces import ILogosManager
from pyams_i18n.interfaces import II18n
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IContentTitle
from pyams_skin.interfaces.viewlet import IMenuHeader, IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.adapter import ContextRequestAdapter, ContextRequestViewAdapter, adapter_config
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.interfaces.menu import IContentManagementMenu
from pyams_zmi.layer import IAdminLayer

from pyams_content import _


@adapter_config(context=(IWfLogo, IContentManagementMenu), provides=IMenuHeader)
class LogoContentMenuHeader(ContextRequestAdapter):
    """Logo content menu header adapter"""

    header = _("This logo")


@adapter_config(context=(IWfLogo, IPyAMSLayer, Interface), provides=IContentTitle)
class LogoTitleAdapter(ContextRequestViewAdapter):
    """Logo title adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("Logo « {title} »")).format(
            title=II18n(self.context).query_attribute('title', request=self.request))


@viewlet_config(name='add-shared-content.action', context=ILogosManager, layer=IAdminLayer, view=Interface,
                manager=IWidgetTitleViewletManager, permission=CREATE_CONTENT_PERMISSION, weight=1)
class LogoAddAction(ToolbarAction):
    """Logo adding action"""

    label = _("Add logo")
    label_css_class = 'fa fa-fw fa-plus'
    url = 'add-shared-content.html'
    modal_target = True


@pagelet_config(name='add-shared-content.html', context=ILogosManager, layer=IPyAMSLayer,
                permission=CREATE_CONTENT_PERMISSION)
class LogoAddForm(SharedContentAddForm):
    """Logo add form"""

    legend = _("Add logo")


@view_config(name='add-shared-content.json', context=ILogosManager, request_type=IPyAMSLayer,
             permission=CREATE_CONTENT_PERMISSION, renderer='json', xhr=True)
class LogoAJAXAddForm(SharedContentAJAXAddForm, LogoAddForm):
    """Logo add form, JSON renderer"""
