#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface
from zope.schema import Choice, TextLine, URI

from pyams_content import _
from pyams_content.component.paragraph import IBaseParagraph
from pyams_content.shared.common.interfaces import ISharedContent, ISharedTool, IWfSharedContent
from pyams_file.schema import ImageField
from pyams_i18n.schema import I18nTextLineField
from pyams_sequence.interfaces import IInternalReference
from pyams_sequence.schema import InternalReferenceField, InternalReferencesListField


LOGO_CONTENT_TYPE = 'logo'
LOGO_CONTENT_NAME = _("Logo")


class ILogosManager(ISharedTool):
    """Logos manager interface"""


class ILogosManagerFactory(Interface):
    """Logos manager factory interface"""


class IWfLogo(IWfSharedContent, IInternalReference):
    """Logo interface"""

    title = I18nTextLineField(title=_("Title"),
                              description=_("Full name of logo organization"),
                              required=True)

    acronym = TextLine(title=_("Acronym"),
                       description=_("Matching logo acronym, without spaces or separators"),
                       required=False)

    url = URI(title=_("Target URL"),
              description=_("URL used to access external resource"),
              required=False)

    reference = InternalReferenceField(title=_("Internal reference"),
                                       description=_("Internal link target reference. You can "
                                                     "search a reference using '+' followed by "
                                                     "internal number, of by entering text "
                                                     "matching content title."),
                                       required=False)

    alt_title = I18nTextLineField(title=_("Alternate title"),
                                  description=_("If set, this title will be displayed in "
                                                "front-office instead of original title"),
                                  required=False)

    image = ImageField(title=_("Image (colored)"),
                       description=_("Image data"),
                       required=True)

    monochrome_image = ImageField(title=_("Image (monochrome)"),
                                  description=_("An alternate image which can be used by some "
                                                "presentation templates"),
                                  required=False)


class IWfLogoFactory(Interface):
    """Logo factory interface"""


class ILogo(ISharedContent):
    """Workflow managed logo interface"""


LOGOS_PARAGRAPH_TYPE = 'Logos'
LOGOS_PARAGRAPH_NAME = _("Logos")
LOGOS_PARAGRAPH_RENDERERS = 'PyAMS.shared.logos.renderers'


class ILogosParagraph(IBaseParagraph):
    """Logos paragraph"""

    logos = InternalReferencesListField(title=_("Logos references"),
                                        description=_("List of internal logos references"),
                                        content_type=LOGO_CONTENT_TYPE)

    def get_logos(self, status=None, with_reference=False, getter=None):
        """Get logos from internal references"""

    renderer = Choice(title=_("Logos template"),
                      description=_("Presentation template used for this paragraph"),
                      vocabulary=LOGOS_PARAGRAPH_RENDERERS,
                      default='default')
