#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.shared.imagemap.interfaces import IWfImageMap
from pyams_i18n.interfaces import II18n
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_form.widget import widgettemplate_config
from pyams_utils.traversing import get_parent
from pyams_utils.url import absolute_url
from z3c.form.browser.text import TextWidget
from z3c.form.widget import FieldWidget


@widgettemplate_config(mode='input', template='templates/widget-input.pt', layer=IPyAMSLayer)
class ImgareaInputWidget(TextWidget):
    """Image map area input widget"""

    @property
    def image_url(self):
        map = get_parent(self.context, IWfImageMap)
        return absolute_url(II18n(map).query_attribute('image', request=self.request), self.request)


def ImgareaInputFieldWidget(field, request):
    """Image map area input widget factory"""
    return FieldWidget(field, ImgareaInputWidget(request))
