#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyams_content.shared.imagemap import IMAGEMAP_CONTENT_TYPE
from pyams_i18n.schema import I18nTextLineField
from pyams_portal.interfaces import IPortletSettings
from pyams_sequence.interfaces import IInternalReference
from pyams_sequence.schema import InternalReferenceField


__docformat__ = 'restructuredtext'

from pyams_content import _


class IImageMapPortletSettings(IPortletSettings, IInternalReference):
    """Image map portlet settings interface"""

    title = I18nTextLineField(title=_("Title"),
                              required=False)

    reference = InternalReferenceField(title=_("Internal reference"),
                                       description=_("Reference to image map object"),
                                       content_type=IMAGEMAP_CONTENT_TYPE)
