#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.links import InternalReferenceMixin
from pyams_content.shared.imagemap.portlet.interfaces import IImageMapPortletSettings
from pyams_portal.portlet import PortletSettings, portlet_config, Portlet
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION


__docformat__ = 'restructuredtext'

from pyams_content import _


IMAGEMAP_PORTLET_NAME = 'pyams_content.portlet.imagemap'


@factory_config(provided=IImageMapPortletSettings)
class ImageMapPortletSettings(PortletSettings, InternalReferenceMixin):
    """Image map portlet settings"""

    title = FieldProperty(IImageMapPortletSettings['title'])
    reference = FieldProperty(IImageMapPortletSettings['reference'])


@portlet_config(permission=VIEW_PERMISSION)
class ImageMapPortlet(Portlet):
    """Image map portlet"""

    name = IMAGEMAP_PORTLET_NAME
    label = _("Image map")

    toolbar_image = None
    toolbar_css_class = 'fa fa-fw fa-2x fa-location-arrow'

    settings_factory = IImageMapPortletSettings
