#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.shared.common.zmi.properties import SharedContentPropertiesEditForm
from pyams_content.shared.file import IWfFile
from pyams_form.form import ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.event import get_json_form_refresh_event
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION


@pagelet_config(name='properties.html',
                context=IWfFile, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='properties.json',
             context=IWfFile, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
class FileMainPropertiesEditForm(SharedContentPropertiesEditForm):
    """File properties edit form"""

    interface = IWfFile
    fieldnames = ('title', 'content_url', 'data', 'filename', 'notepad')

    def get_ajax_output(self, changes):
        output = super().get_ajax_output(changes)
        updated = changes.get(IWfFile, ())
        if updated:
            output.setdefault('events', []).extend([
                get_json_form_refresh_event(self.context, self.request, FileMainPropertiesEditForm)
            ])
        return output
