#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from pyramid.view import view_config
from zope.interface import Interface

from pyams_content.interfaces import CREATE_CONTENT_PERMISSION
from pyams_content.shared.common.zmi import SharedContentAJAXAddForm, SharedContentAddForm
from pyams_content.shared.file import IWfFile
from pyams_content.shared.file.interfaces import IFilesManager
from pyams_i18n.interfaces import II18n
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IContentTitle
from pyams_skin.interfaces.viewlet import IMenuHeader, IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.adapter import ContextRequestAdapter, ContextRequestViewAdapter, adapter_config
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.interfaces.menu import IContentManagementMenu


__docformat__ = 'restructuredtext'

from pyams_content import _
from pyams_zmi.layer import IAdminLayer


@adapter_config(context=(IWfFile, IContentManagementMenu),
                provides=IMenuHeader)
class FileContentMenuHeader(ContextRequestAdapter):
    """File content menu header adapter"""

    header = _("This file")


@adapter_config(context=(IWfFile, IPyAMSLayer, Interface),
                provides=IContentTitle)
class FileTitleAdapter(ContextRequestViewAdapter):
    """File title adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("File « {title} »")).format(
            title=II18n(self.context).query_attribute('title', request=self.request))


@viewlet_config(name='add-shared-content.action',
                context=IFilesManager, layer=IAdminLayer, view=Interface,
                manager=IWidgetTitleViewletManager, weight=1,
                permission=CREATE_CONTENT_PERMISSION)
class FileAddAction(ToolbarAction):
    """File adding action"""

    label = _("Add file")
    label_css_class = 'fa fa-fw fa-plus'
    url = 'add-shared-content.html'
    modal_target = True


@pagelet_config(name='add-shared-content.html',
                context=IFilesManager, layer=IPyAMSLayer,
                permission=CREATE_CONTENT_PERMISSION)
class FileAddForm(SharedContentAddForm):
    """File add form"""

    legend = _("Add file")


@view_config(name='add-shared-content.json',
             context=IFilesManager, request_type=IPyAMSLayer,
             permission=CREATE_CONTENT_PERMISSION,
             renderer='json', xhr=True)
class FileAJAXAddForm(SharedContentAJAXAddForm, FileAddForm):
    """File add form, JSON renderer"""
