#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from pyramid.events import subscriber
from zope.annotation.interfaces import IAttributeAnnotatable
from zope.component.interfaces import ISite
from zope.interface import implementer
from zope.lifecycleevent.interfaces import IObjectAddedEvent

from pyams_content.shared.common.interfaces import ISharedContentFactory
from pyams_content.shared.common.manager import SharedTool
from pyams_content.shared.file import File
from pyams_content.shared.file.interfaces import FILE_CONTENT_TYPE, IFilesManager, \
    IFilesManagerFactory
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import utility_config
from pyams_utils.traversing import get_parent


__docformat__ = 'restructuredtext'


@implementer(IFilesManager, IAttributeAnnotatable)
class FilesManager(SharedTool):
    """Files manager class"""

    shared_content_type = FILE_CONTENT_TYPE
    shared_content_menu = False


@utility_config(provides=IFilesManagerFactory)
class FilesManagerFactory(object):
    """Default files manager factory"""

    def __new__(cls):
        return FilesManager


@adapter_config(context=IFilesManager, provides=ISharedContentFactory)
def files_manager_content_factory(context):
    """Files manager content factory"""
    return File


@subscriber(IObjectAddedEvent, context_selector=IFilesManager)
def handle_added_files_manager(event):
    """Register files manager when added"""
    site = get_parent(event.newParent, ISite)
    registry = site.getSiteManager()
    if registry is not None:
        registry.registerUtility(event.object, IFilesManager)
