#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface

from pyams_content.shared.common.interfaces import ISharedContent, IWfSharedContent, ISharedTool
from pyams_file.schema import FileField
from pyams_i18n.schema import I18nTextLineField


__docformat__ = 'restructuredtext'

from pyams_content import _


FILE_CONTENT_TYPE = 'file'
FILE_CONTENT_NAME = _("File")


class IFilesManager(ISharedTool):
    """Files manager interface"""


class IFilesManagerFactory(Interface):
    """Files manager factory interfaces"""


class IWfFile(IWfSharedContent):
    """Shared file interface"""

    data = FileField(title=_("File data"),
                     description=_("Actual file content"),
                     required=True)

    filename = I18nTextLineField(title=_("File name"),
                                 description=_("Name used to save the file on download"),
                                 required=False)


class IWfFileFactory(Interface):
    """Logo factory interface"""


class IFile(ISharedContent):
    """Workflow managed file interface"""
