#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.shared.common.interfaces import ISharedSite
from pyams_content.shared.common.interfaces.zmi import IDashboardSearchHeader
from pyams_i18n.interfaces import II18n
from pyams_zmi.layer import IAdminLayer

# import packages
from pyams_content.shared.common.zmi.dashboard import SharedToolDashboardView
from pyams_utils.adapter import adapter_config, ContextRequestViewAdapter

from pyams_content import _


@adapter_config(context=(ISharedSite, IAdminLayer, SharedToolDashboardView), provides=IDashboardSearchHeader)
class SharedSiteDashboardSearchHeaderAdapter(ContextRequestViewAdapter):
    """Site manager dashboard search header adapter"""

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("SEARCH - Between all contents published into &laquo;&nbsp;{site}&nbsp;&raquo;")).format(
            site=II18n(self.context).query_attribute('title', request=self.request)
        )
