#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

from pyams_content import _
# import interfaces
from pyams_content.shared.common import IWfSharedContent
from pyams_content.shared.common.interfaces import IWfSharedContentPortalContext, ISharedToolPortalContext
from pyams_content.shared.common.interfaces.types import ITypedSharedToolPortalContext
# import packages
from pyams_form.form import ajax_config
from pyams_form.help import FormHelp
from pyams_form.interfaces.form import IFormHelp
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.interfaces import MANAGE_TEMPLATE_PERMISSION
from pyams_portal.zmi.page import PortalContextTemplatePropertiesEditForm
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_zmi.layer import IAdminLayer


@pagelet_config(name='template-properties.html', context=ISharedToolPortalContext, layer=IPyAMSLayer,
                permission=MANAGE_TEMPLATE_PERMISSION)
@pagelet_config(name='template-properties.html', context=ITypedSharedToolPortalContext, layer=IPyAMSLayer,
                permission=MANAGE_TEMPLATE_PERMISSION)
@ajax_config(name='template-properties.json', context=ISharedToolPortalContext, layer=IPyAMSLayer)
@ajax_config(name='template-properties.json', context=ITypedSharedToolPortalContext, layer=IPyAMSLayer)
class SharedToolTemplatePropertiesEditForm(PortalContextTemplatePropertiesEditForm):
    """Shared content template properties edit form"""

    legend = _("Edit default template properties")


@adapter_config(context=(ISharedToolPortalContext, IAdminLayer, SharedToolTemplatePropertiesEditForm),
                provides=IFormHelp)
@adapter_config(context=(ITypedSharedToolPortalContext, IAdminLayer, SharedToolTemplatePropertiesEditForm),
                provides=IFormHelp)
class SharedToolPortalContextPropertiesEditFormHelpAdapter(FormHelp):
    """Shared tool template properties edit form help adapter"""

    message = _("**This form allows you to select shared content default template.**\n"
                "\n"
                "If you choose to use a shared template, you can only adjust settings of "
                "each portlet individually but can't change portlets list or page configuration.\n"
                "\n"
                "If you use a local template, you can define a whole custom "
                "configuration but the template definition can't be reused anywhere...""")
    message_format = 'rest'


@pagelet_config(name='template-properties.html', context=IWfSharedContentPortalContext, layer=IPyAMSLayer,
                permission=MANAGE_TEMPLATE_PERMISSION)
@ajax_config(name='template-properties.json', context=IWfSharedContent, layer=IPyAMSLayer)
class SharedContentTemplatePropertiesEditForm(PortalContextTemplatePropertiesEditForm):
    """Shared content template properties edit form"""

    inherit_legend = _("Use tool default template")
