#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_skin.interfaces.container import ITable

# import packages
from zope.interface import Interface, Attribute


class IDashboardSearchHeader(Interface):
    """Dashboard search header adapter"""

    title = Attribute("Header title")


class IDashboardTable(ITable):
    """Base dashboard table marker interface"""


class ISharedToolDashboardTable(IDashboardTable):
    """Shared tool dashboard table marker interface"""


class ISiteRootDashboardTable(IDashboardTable):
    """Site root dashboard table marker interface"""


class IDashboardTypeColumnValue(Interface):
    """Dashboard content type column interface"""
