#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.schema import Choice

from pyams_content.component.paragraph import IBaseParagraph

from pyams_content import _


SHARED_CONTENT_SPECIFICITIES_PARAGRAPH_RENDERERS = 'pyams_content.content_specificities.renderers'


class ISharedContentSpecificitiesParagraph(IBaseParagraph):
    """Shared content specificities portlet settings"""

    renderer = Choice(title=_("Specificities renderer"),
                      description=_("Presentation template used for content specificities"),
                      vocabulary=SHARED_CONTENT_SPECIFICITIES_PARAGRAPH_RENDERERS,
                      default='default')
