#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form import field

from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.shared.alert import IWfAlert
from pyams_content.shared.common.zmi.properties import SharedContentPropertiesEditForm
from pyams_content.shared.common.zmi.summary import SharedContentDublinCoreSummary, \
    SharedContentSummaryForm
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IInnerSubForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_sequence.interfaces import ISequentialIdInfo
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import NullAdapter, adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import InnerAdminEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer


__docformat__ = 'restructuredtext'

from pyams_content import _


@adapter_config(name='dublincore-summary',
                required=(IWfAlert, IPyAMSLayer, SharedContentSummaryForm),
                provides=IInnerSubForm)
class AlertDublinCoreSummary(SharedContentDublinCoreSummary):
    """Shared content DublinCore summary"""

    fields = field.Fields(IWfAlert).select('title') + \
        field.Fields(ISequentialIdInfo).select('public_oid')


@pagelet_config(name='properties.html',
                context=IWfAlert, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='properties.json',
             context=IWfAlert, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
class AlertMainPropertiesEditForm(SharedContentPropertiesEditForm):
    """Alert properties edit form"""

    interface = IWfAlert
    fieldnames = ('title', 'alert_type', 'notepad')


@adapter_config(name='alert-settings',
                required=(IWfAlert, IPyAMSLayer, SharedContentPropertiesEditForm),
                provides=IInnerSubForm)
class AlertPropertiesEditForm(InnerAdminEditForm):
    """Alert properties edit form extension"""

    prefix = 'alert_settings.'

    legend = _("Main alert settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = field.Fields(IWfAlert).select('body', 'reference', 'external_url',
                                           'references', 'maximum_interval')
    weight = 1

    def get_ajax_output(self, changes):
        if changes:
            return {
                'status': 'reload',
                'message': self.request.localizer.translate(self.successMessage)
            }
        return super().get_ajax_output(changes)


@viewlet_config(name='references.menu',
                context=IWfAlert, layer=IAdminLayer,
                manager=IPropertiesMenu, weight=300,
                permission=VIEW_SYSTEM_PERMISSION)
class ReferencesMenu(NullAdapter):
    """Disabled references menu"""
