#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from colander import Int, MappingSchema, SchemaNode, SequenceSchema, String, drop

from pyams_content.reference.pictograms.api.schema import PictogramInfo
from pyams_content.shared.common.api import SharedContentInfo
from pyams_utils.rest import BaseResponseSchema


class AlertTypeInfo(MappingSchema):
    """Alert type schema"""
    name = SchemaNode(String(),
                      description="Alert type name")
    label = SchemaNode(String(),
                       description="Alert type label")
    pictogram = PictogramInfo(description="Pictogram information")
    color = SchemaNode(String(),
                       description="Alert type base color, in RGB hexa value")


class AlertTypesList(SequenceSchema):
    """Alert types list schema"""
    alert_type = AlertTypeInfo()


class AlertTypesGetterResult(BaseResponseSchema):
    """Alert types getter result"""
    alert_types = AlertTypesList(description="Alert types list",
                                 missing=drop)


class AlertTypesGetterResponse(MappingSchema):
    """Alert types getter response"""
    body = AlertTypesGetterResult()


class AlertSpecificitiesInfo(MappingSchema):
    """Alert specificities information schema"""
    alert_type = SchemaNode(String(),
                            description="Alert type")
    body = SchemaNode(String(),
                      description="Alert message body",
                      missing=drop)
    href = SchemaNode(String(),
                      description="Optional link URL",
                      missing=drop)
    display_interval = SchemaNode(Int(),
                                  description="Display interval, in hours",
                                  missing=48)


class AlertInfo(SharedContentInfo):
    """Alert information schema"""
    alert = AlertSpecificitiesInfo(description="Alert specificities info",
                                   missing=drop)
