#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

import argparse
import sys
import textwrap

from pyramid.paster import bootstrap

from pyams_content.features.catalog import site_index


def index_site():
    """Update all ElasticSearch indexes"""
    usage = "usage: {0} config_uri".format(sys.argv[0])
    description = """Update all internal catalog indexes with all database contents."""

    parser = argparse.ArgumentParser(usage=usage,
                                     description=textwrap.dedent(description))
    parser.add_argument('config_uri', help='Name of configuration file')
    args = parser.parse_args()

    config_uri = args.config_uri
    env = bootstrap(config_uri)
    settings, closer = env['registry'].settings, env['closer']
    try:
        site_index(env['request'])
    finally:
        closer()
