#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""
from z3c.form import field

from pyams_content import _
from pyams_content.reference.pictograms.interfaces import IThesaurusTermPictogramsInfo, IThesaurusTermPictogramsTarget
from pyams_content.reference.pictograms.zmi.widget import PictogramSelectFieldWidget
from pyams_form.form import ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer
from pyams_thesaurus.interfaces import MANAGE_THESAURUS_CONTENT_PERMISSION
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_zmi.form import AdminDialogEditForm


@pagelet_config(name='pictograms-description.html',
                context=IThesaurusTermPictogramsTarget, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='pictograms-description.json',
             context=IThesaurusTermPictogramsTarget, layer=IPyAMSLayer)
class ThesaurusTermPictogramsPropertiesEditForm(AdminDialogEditForm):

    prefix = 'pictograms_form.'

    legend = _("Edit pictograms")
    dialog_class = ''
    icon_css_class = 'fa fa-fw fa-font '

    # fields = field.Fields(IThesaurusTermPictogramsInfo)

    @property
    def fields(self):
        fields = field.Fields(IThesaurusTermPictogramsInfo)
        fields['pictogram_on'].widgetFactory = PictogramSelectFieldWidget
        fields['pictogram_off'].widgetFactory = PictogramSelectFieldWidget
        return fields

    edit_permission = MANAGE_THESAURUS_CONTENT_PERMISSION

    def getContent(self):
        return IThesaurusTermPictogramsInfo(self.context)
