#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from colander import String, SchemaNode, MappingSchema, drop


class PictogramInfo(MappingSchema):
    """Pictogram information schema"""
    content_type = SchemaNode(String(),
                              description="Pictogram content type")
    src = SchemaNode(String(),
                     description="Image source URL")


class PictogramsMapping(MappingSchema):
    """Pictograms mapping schema"""
    default = PictogramInfo(description="Default pictogram info",
                            missing=drop)
    on = PictogramInfo(description="'ON' pictogram info",
                       missing=drop)
    off = PictogramInfo(description="'OFF' pictogram info",
                        missing=drop)
