#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from zope.annotation.interfaces import IAttributeAnnotatable

# import packages
from zope.schema import Choice, List, TextLine

from pyams_content import _


ADMIN_PROFILE_KEY = 'pyams_content.admin_profile'


class IAdminProfile(IAttributeAnnotatable):
    """User admin profile preferences"""

    favorites = List(title=_("User favorites"),
                     description=_("List of internal numbers of shared contents stored for quick access"),
                     value_type=TextLine())

    table_page_length = Choice(title=_("Default table length"),
                               description=_("Default length used for inner tables and dashboards"),
                               values=(10, 25, 50, 100),
                               default=10)
