#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from persistent import Persistent
from pyramid.security import ALL_PERMISSIONS, Allow, Everyone
from zope.interface import Interface
from zope.schema.fieldproperty import FieldProperty

from pyams_content.profile.interfaces import ADMIN_PROFILE_KEY, IAdminProfile
from pyams_security.interfaces import IPrincipalInfo
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import PUBLIC_PERMISSION
from pyams_utils.request import check_request, query_request


@factory_config(IAdminProfile)
class AdminProfile(Persistent):
    """Admin profile persistent class"""

    favorites = FieldProperty(IAdminProfile['favorites'])
    table_page_length = FieldProperty(IAdminProfile['table_page_length'])

    @staticmethod
    def __acl__():
        result = [(Allow, 'system:admin', ALL_PERMISSIONS)]
        request = query_request()
        if request is not None:
            result.append((Allow, request.principal.id, ALL_PERMISSIONS))
        result.append((Allow, Everyone, PUBLIC_PERMISSION))
        return result


@adapter_config(context=Interface, provides=IAdminProfile)
def admin_profile_factory(context):
    request = check_request()
    return IAdminProfile(request.principal)


@adapter_config(context=IPrincipalInfo, provides=IAdminProfile)
def principal_admin_profile_factory(principal):
    """Principal admin profile factory adapter"""
    return get_annotation_adapter(principal, ADMIN_PROFILE_KEY, IAdminProfile)
