#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

# import standard library

# import interfaces
from zope.container.interfaces import IContainer

# import packages
from zope.interface import Interface


#
# Containers interfaces
#

class IOrderedContainerOrder(Interface):
    """Ordered containers interface"""

    def updateOrder(self, order):
        """Reset items in given order

        @order: new ordered list of container's items keys
        """

    def moveFirst(self, key):
        """Move item with given key to first position"""

    def moveUp(self, key):
        """Move item with given key one position up"""

    def moveDown(self, key):
        """Move item with given key one position down"""

    def moveLast(self, key):
        """Move item with given key to last position"""


class IOrderedContainer(IContainer, IOrderedContainerOrder):
    """Marker interface for ordered containers"""
