#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.component.paragraph import IParagraphContainer, IParagraphContainerTarget
from pyams_content.shared.logo.interfaces import ILogosParagraph
from pyams_i18n.interfaces import II18n
from pyams_utils.container import find_objects_providing
from pyams_utils.registry import get_local_registry, set_local_registry


def evolve(site):
    """Evolve 2: rename resource annotations"""
    registry = get_local_registry()
    try:
        set_local_registry(site.getSiteManager())
        for container in find_objects_providing(site, IParagraphContainerTarget):
            for paragraph in IParagraphContainer(container).values():
                if not ILogosParagraph.providedBy(paragraph):
                    continue
                print("Upgrading logos for case study « {} »".format(II18n(container).query_attribute('title')))
                paragraph.logos = paragraph.references.copy()
                del paragraph.references
    finally:
        set_local_registry(registry)
