#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form import field

from pyams_content.features.thesaurus import IThesaurusTermHTMLTarget
from pyams_content.features.thesaurus.interfaces import IThesaurusTermHTMLInfo
from pyams_form.form import ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer
from pyams_thesaurus.interfaces import MANAGE_THESAURUS_CONTENT_PERMISSION
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_zmi.form import AdminDialogEditForm

from pyams_content import _


@pagelet_config(name='html-description.html', context=IThesaurusTermHTMLTarget, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='html-description.json', context=IThesaurusTermHTMLTarget, layer=IPyAMSLayer)
class ThesaurusTermHTMLDescriptionPropertiesEditForm(AdminDialogEditForm):
    """Thesaurus term HTML description properties edit form"""

    prefix = 'html_description_form.'

    legend = _("Edit rich text description")
    dialog_class = 'modal-max'
    icon_css_class = 'fa fa-fw fa-font'

    fields = field.Fields(IThesaurusTermHTMLInfo)
    edit_permission = MANAGE_THESAURUS_CONTENT_PERMISSION

    def getContent(self):
        return IThesaurusTermHTMLInfo(self.context)
