#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.annotation import IAttributeAnnotatable
from zope.interface import Interface

from pyams_i18n.schema import I18nHTMLField


__docformat__ = 'restructuredtext'

from pyams_content import _


THESAURUS_TERM_HTML_INFO_KEY = 'pyams_content.term.html_info'


class IThesaurusTermHTMLInfo(Interface):
    """Thesaurus term HTML info"""

    description = I18nHTMLField(title=_("HTML content"),
                                required=False)


class IThesaurusTermHTMLTarget(IAttributeAnnotatable):
    """Thesaurus term HTML description target"""
