#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_content.features.share.portlet import IToolboxPortletSettings
from pyams_form.form import AJAXEditForm
from pyams_pagelet.interfaces import IPagelet
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.interfaces import IPortletPreviewer
from pyams_portal.portlet import PortletPreviewer
from pyams_portal.zmi.portlet import PortletSettingsEditor
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION


@pagelet_config(name='properties.html', context=IToolboxPortletSettings, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
class ToolboxPortletSettingsEditor(PortletSettingsEditor):
    """Toolbox portlet settings editor"""

    settings = IToolboxPortletSettings


@adapter_config(name='properties.json', context=(IToolboxPortletSettings, IPyAMSLayer), provides=IPagelet)
class ToolboxPortletSettingsAJAXEditor(AJAXEditForm, ToolboxPortletSettingsEditor):
    """Toolbox portlet settings editor, JSON renderer"""


@adapter_config(context=(Interface, IPyAMSLayer, Interface, IToolboxPortletSettings),
                provides=IPortletPreviewer)
@template_config(template='templates/toolbox-preview.pt', layer=IPyAMSLayer)
class ToolboxPortletPreviewer(PortletPreviewer):
    """Toolbox portlet previewer"""
