#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.schema.fieldproperty import FieldProperty

from pyams_content.features.share.portlet.interfaces import IToolboxPortletSettings
from pyams_portal.portlet import Portlet, PortletSettings, portlet_config
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION

from pyams_content import _


TOOLBOX_PORTLET_NAME = 'pyams_content.portlet.toolbox'


@factory_config(provided=IToolboxPortletSettings)
class ToolboxPortletSettings(PortletSettings):
    """Toolbox portlet settings"""

    allow_printing = FieldProperty(IToolboxPortletSettings['allow_printing'])
    allow_sharing = FieldProperty(IToolboxPortletSettings['allow_sharing'])


@portlet_config(permission=VIEW_PERMISSION)
class ToolboxPortet(Portlet):
    """Toolbox portlet"""

    name = TOOLBOX_PORTLET_NAME
    label = _("Toolbox")

    toolbar_css_class = 'fa fa-fw fa-2x fa-print'

    settings_factory = IToolboxPortletSettings
