#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form import field

from pyams_content import _
from pyams_content.component.theme import ICollectionsManager, ICollectionsManagerTarget, IThemesManager, \
    IThemesManagerTarget
from pyams_content.features.search import ISearchFolder
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.shared.view.interfaces import IViewCollectionsSettings, IViewTagsSettings, IViewThemesSettings
from pyams_content.shared.view.zmi.theme import ViewCollectionsEditForm, ViewTagsEditForm, ViewThemesEditForm
from pyams_form.form import ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer
from pyams_thesaurus.zmi.widget import ThesaurusTermsTreeFieldWidget
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_utils.traversing import get_parent


@pagelet_config(name='tags.html', context=ISearchFolder, layer=IPyAMSLayer, permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='tags.json', context=ISearchFolder, layer=IPyAMSLayer, permission=MANAGE_CONTENT_PERMISSION)
class SearchFolderTagsEditForm(ViewTagsEditForm):
    """Search folder tags settings edit form"""

    legend = _("Search folder tags settings")

    fields = field.Fields(IViewTagsSettings).select('tags')
    fields['tags'].widgetFactory = ThesaurusTermsTreeFieldWidget

    def updateWidgets(self, prefix=None):
        super(SearchFolderTagsEditForm, self).updateWidgets(prefix)
        if 'tags' in self.widgets:
            self.widgets['tags'].label_css_class = 'hidden'


@pagelet_config(name='themes.html', context=ISearchFolder, layer=IPyAMSLayer, permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='themes.json', context=ISearchFolder, layer=IPyAMSLayer, permission=MANAGE_CONTENT_PERMISSION)
class SearchFolderThemesEditForm(ViewThemesEditForm):
    """Search folder themes settings edit form"""

    legend = _("Search folder themes settings")

    fields = field.Fields(IViewThemesSettings).select('themes')
    fields['themes'].widgetFactory = ThesaurusTermsTreeFieldWidget

    def updateWidgets(self, prefix=None):
        super(ViewThemesEditForm, self).updateWidgets(prefix)
        if 'themes' in self.widgets:
            target = get_parent(self.context, IThemesManagerTarget)
            manager = IThemesManager(target)
            widget = self.widgets['themes']
            widget.label_css_class = 'hidden'
            widget.input_css_class = 'col-md-12'
            widget.thesaurus_name = manager.thesaurus_name
            widget.extract_name = manager.extract_name


@pagelet_config(name='collections.html', context=ISearchFolder, layer=IPyAMSLayer, permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='collections.json', context=ISearchFolder, layer=IPyAMSLayer, permission=MANAGE_CONTENT_PERMISSION)
class SearchFolderCollectionsEditForm(ViewCollectionsEditForm):
    """Search folder collections settings edit form"""

    legend = _("Search folder collections settings")

    fields = field.Fields(IViewCollectionsSettings).select('collections')
    fields['collections'].widgetFactory = ThesaurusTermsTreeFieldWidget

    def updateWidgets(self, prefix=None):
        super(ViewCollectionsEditForm, self).updateWidgets(prefix)
        if 'collections' in self.widgets:
            target = get_parent(self.context, ICollectionsManagerTarget)
            manager = ICollectionsManager(target)
            widget = self.widgets['collections']
            widget.label_css_class = 'hidden'
            widget.input_css_class = 'col-md-12'
            widget.thesaurus_name = manager.thesaurus_name
            widget.extract_name = manager.extract_name
