#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.decorator import reify
from z3c.form import field
from zope.interface import Interface

from pyams_content.features.renderer.interfaces import IContentRenderer, IRenderedContent, IRendererSettings
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IFormManager
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer
from pyams_viewlet.viewlet import BaseContentProvider
from pyams_zmi.form import AdminDialogEditForm

from pyams_content import _


#
# Base rendered content renderer
#

class BaseRenderedContentRenderer(BaseContentProvider):
    """Base content renderer"""

    language = None

    def __init__(self, context, request):
        super(BaseRenderedContentRenderer, self).__init__(context, request)
        self.renderer = self.context.get_renderer(request)

    def update(self):
        renderer = self.renderer
        if renderer is not None:
            renderer.update()

    def render(self, template_name=''):
        if self.renderer is None:
            return ''
        return self.renderer.render(template_name)


#
# Base content renderer edit form
#

@pagelet_config(name='renderer-properties.html', context=IRenderedContent, layer=IPyAMSLayer,
                permission=MANAGE_CONTENT_PERMISSION)
@ajax_config(name='renderer-properties.json', context=IRenderedContent, layer=IPyAMSLayer)
class RendererPropertiesEditForm(AdminDialogEditForm):
    """Renderer properties edit form"""

    prefix = 'renderer_properties.'

    legend = _("Edit renderer properties")
    icon_css_class = 'fa fa-fw fa-pencil-square-o'

    @reify
    def manager(self):
        content = self.getContent()
        return self.request.registry.queryMultiAdapter((content, self.request, self), IFormManager)

    @reify
    def fields(self):
        if self.manager is not None:
            return self.manager.getFields()
        else:
            renderer = IContentRenderer(self.context)
            return field.Fields(renderer.settings_interface or Interface)

    edit_permission = MANAGE_CONTENT_PERMISSION

    def getContent(self):
        return IRendererSettings(self.context)

    def update(self):
        if self.manager is not None:
            self.manager.update()
        else:
            super(RendererPropertiesEditForm, self).update()

    def updateWidgets(self, prefix=None):
        if self.manager is not None:
            self.manager.updateWidgets(prefix)
        else:
            super(RendererPropertiesEditForm, self).updateWidgets(prefix)

    def updateActions(self):
        if self.manager is not None:
            self.manager.updateActions()
        else:
            super(RendererPropertiesEditForm, self).updateActions()

    def updateGroups(self):
        if self.manager is not None:
            self.manager.updateGroups()
        else:
            super(RendererPropertiesEditForm, self).updateGroups()
