#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.annotation import IAttributeAnnotatable
from zope.contentprovider.interfaces import IContentProvider
from zope.interface import Attribute, Interface


HIDDEN_RENDERER_NAME = 'hidden'


class IRenderedContent(IAttributeAnnotatable):
    """Generic interface for any rendered content"""

    renderer = Attribute("Selected renderer name")

    def get_renderer(self, request=None):
        """Get selected renderer implementation"""


class IFakeVocabularyContent(Interface):
    """Fake vocabulary content interface

    This interface is used to mark fake objects which have been created only to
    feed renderers vocabularies...
    """


class IContentRenderer(IContentProvider):
    """Content renderer interface"""

    label = Attribute("Renderer label")
    weight = Attribute("Renderer weight, used for ordering")

    settings_interface = Attribute("Renderer settings interface")
    resources = Attribute("Iterable of needed Fanstatic resources")

    language = Attribute("Renderer language (if forced)")
    context_attrs = Attribute("Context attributes defined into renderer")
    i18n_context_attrs = Attribute("I18n context attributes defined into renderer")


class ISharedContentRenderer(IContentRenderer):
    """Shared content renderer interface"""


class IRendererSettings(Interface):
    """Base renderer settings interface"""
