#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.features.preview.interfaces import IPreviewTarget
from pyams_content.features.preview.zmi.interfaces import IPreviewForm
from pyams_i18n.interfaces import II18nManager, INegotiator
from pyams_skin.interfaces.viewlet import IToolbarViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_zmi.layer import IAdminLayer

# import packages
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_template.template import template_config
from pyams_utils.registry import get_utility
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminDialogDisplayForm
from z3c.form import field
from zope.interface import implementer, Interface

from pyams_content import _


@viewlet_config(name='preview.action', context=IPreviewTarget, layer=IAdminLayer, view=Interface,
                manager=IToolbarViewletManager, permisison=VIEW_SYSTEM_PERMISSION, weight=50)
@template_config(template='templates/preview-action.pt', layer=IAdminLayer)
class PreviewAction(ToolbarAction):
    """Content preview action"""

    label = _("Preview")

    group_css_class = 'btn-group margin-right-5'
    label_css_class = 'fa fa-fw fa-binoculars'
    css_class = 'btn btn-xs btn-default'

    url = 'content-preview.html'
    modal_target = True


@pagelet_config(name='content-preview.html', context=IPreviewTarget, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@template_config(template='templates/preview.pt', layer=IPyAMSLayer)
@implementer(IPreviewForm)
class PreviewForm(AdminDialogDisplayForm):
    """Content preview form"""

    legend = _("Content preview")

    @property
    def title(self):
        translate = self.request.localizer.translate
        return translate(_("{title} ({preview})")).format(title=super(PreviewForm, self).title,
                                                          preview=translate(_("preview")))

    dialog_class = 'modal-max'

    fields = field.Fields(Interface)
    languages = None

    def __init__(self, context, request):
        super(PreviewForm, self).__init__(context, request)
        i18n = II18nManager(context, None)
        if i18n is not None:
            self.languages = i18n.get_languages()
        else:
            negotiator = get_utility(INegotiator)
            self.languages = (negotiator.server_language, )
