#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_content import _
from pyams_content.component.association.interfaces import IAssociationInfo
from pyams_content.component.links.interfaces import IInternalLink
from pyams_content.features.menu.portlet.navigation.interfaces.simple import ISimpleNavigationMenu, \
    ISimpleNavigationPortletSettings
from pyams_content.features.menu.zmi import IMenuLinksView, LinksTable, MenuLinksView
from pyams_form.form import AJAXEditForm
from pyams_form.interfaces.form import IInnerSubForm
from pyams_pagelet.interfaces import IPagelet
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.interfaces import IPortletPreviewer
from pyams_portal.portlet import PortletPreviewer
from pyams_portal.zmi.portlet import PortletSettingsEditor, PortletSettingsPropertiesEditor
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_workflow.interfaces import IWorkflowPublicationInfo


@pagelet_config(name='properties.html', context=ISimpleNavigationPortletSettings, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
class SimpleNavigationPortletSettingsEditor(PortletSettingsEditor):
    """Simple navigation portlet settings editor"""

    settings = ISimpleNavigationPortletSettings


@adapter_config(name='properties.json', context=(ISimpleNavigationPortletSettings, IPyAMSLayer), provides=IPagelet)
class SimpleNavigationPortletSettingsAJAXEditor(AJAXEditForm, SimpleNavigationPortletSettingsEditor):
    """Simple navigation portlet settings editor, JSON renderer"""


class SimpleNavigationPortletLinksTable(LinksTable):
    """Simple navigation portlet links table"""

    associations_name = 'links'


@adapter_config(name='simple-navigation-links',
                context=(ISimpleNavigationPortletSettings, IPyAMSLayer, PortletSettingsPropertiesEditor),
                provides=IInnerSubForm)
@adapter_config(name='++ass++links', context=(ISimpleNavigationMenu, IPyAMSLayer), provides=IMenuLinksView)
class SimpleNavigationPortletLinksView(MenuLinksView):
    """Simple navigation portlet links view"""

    title = _("Navigation links")

    table_class = SimpleNavigationPortletLinksTable
    weight = 10


@adapter_config(context=(Interface, IPyAMSLayer, Interface, ISimpleNavigationPortletSettings),
                provides=IPortletPreviewer)
@template_config(template='templates/simple-preview.pt', layer=IPyAMSLayer)
class SimpleNavigationPortletPreviewer(PortletPreviewer):
    """Simple navigation portlet previewer"""

    @classmethod
    def get_link_info(cls, link):
        return IAssociationInfo(link)

    @classmethod
    def get_link_status(cls, link):
        if not IInternalLink.providedBy(link):
            return True
        target = link.get_target()
        if target is not None:
            publication_info = IWorkflowPublicationInfo(target, None)
            if publication_info is not None:
                return publication_info.is_published()
