#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

import logging
import pickle
from ahocorasick import Automaton

from pyams_cache.beaker import get_cache
from pyams_content.component.theme import ITagsManager
from pyams_thesaurus.interfaces.thesaurus import IThesaurus
from pyams_utils.registry import query_utility


logger = logging.getLogger("PyAMS (content)")

GLOSSARY_CACHE_REGION = 'persistent'
GLOSSARY_CACHE_NAME = 'PyAMS::glossary'
GLOSSARY_CACHE_KEY = 'automaton'


def get_glossary_automaton(root):
    """Generate and store glossary automaton"""
    # generate Automaton
    tags_manager = ITagsManager(root)
    if not tags_manager.enable_glossary:
        return
    thesaurus = query_utility(IThesaurus, name=tags_manager.glossary_thesaurus_name)
    if thesaurus is None:
        return
    logger.debug("Building glossary automaton...")
    automaton = Automaton()
    for term in thesaurus.terms.values():
        if term.status == 'published':
            automaton.add_word(term.label, term.label)
    automaton.make_automaton()
    logger.debug("Automaton built with {} terms".format(len(automaton)))
    # store automaton items
    glossary_cache = get_cache(GLOSSARY_CACHE_REGION, GLOSSARY_CACHE_NAME)
    glossary_cache.set_value(GLOSSARY_CACHE_KEY, pickle.dumps(automaton))
    return automaton


def reset_glossary_automaton():
    """Re-initialize glossary automaton"""
    glossary_cache = get_cache(GLOSSARY_CACHE_REGION, GLOSSARY_CACHE_NAME)
    glossary_cache.clear()
