#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.features.renderer.interfaces import IRenderedContent, IContentRenderer, IRendererSettings
from pyams_utils.interfaces.inherit import IInheritInfo
from zope.annotation.interfaces import IAttributeAnnotatable

# import packages
from zope.interface import Attribute
from zope.schema import Choice

from pyams_content import _


FOOTER_SETTINGS_KEY = 'pyams_content.footer'
FOOTER_RENDERER_SETTINGS_KEY = 'pyams_content.footer::{0}'

FOOTER_RENDERERS = 'PyAMS.footer.renderers'


class IFooterSettings(IInheritInfo, IRenderedContent):
    """Footer settings interface"""

    renderer = Choice(title=_("Footer template"),
                      description=_("Presentation template used for this footer"),
                      vocabulary=FOOTER_RENDERERS,
                      required=False,
                      default='hidden')

    settings = Attribute("Renderer settings")


class IFooterTarget(IAttributeAnnotatable):
    """Footer target marker interface"""


class IFooterRenderer(IContentRenderer):
    """Footer renderer interface"""

    name = Attribute("Renderer name")
    settings_key = Attribute("Renderer settings key")
    cache_key = Attribute("Renderer cache key")


class IFooterRendererSettings(IRendererSettings):
    """Footer renderer settings interface"""
