#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.features.checker.interfaces import IContentChecker
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_form.interfaces.form import IWidgetsSuffixViewletsManager
from pyams_skin.interfaces import IInnerPage
from pyams_skin.interfaces.viewlet import IToolbarViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_zmi.layer import IAdminLayer

# import packages
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_viewlet.viewlet import viewlet_config, Viewlet
from pyams_zmi.form import AdminDialogDisplayForm
from z3c.form import field
from zope.interface import Interface

from pyams_content import _


@viewlet_config(name='content-check.action', context=Interface, layer=IAdminLayer,
                view=IInnerPage, manager=IToolbarViewletManager, permission=MANAGE_CONTENT_PERMISSION, weight=55)
class ContentCheckerMenu(ToolbarAction):
    """Content checker menu item"""

    label = _("Audit")

    group_css_class = 'btn-group margin-right-10'
    label_css_class = 'fa fa-fw fa-check-square-o'
    css_class = 'btn btn-xs btn-default'

    url = 'content-check.html'
    modal_target = True


@pagelet_config(name='content-check.html', context=Interface, layer=IPyAMSLayer,
                permission=MANAGE_CONTENT_PERMISSION)
class ContentCheckerForm(AdminDialogDisplayForm):
    """Content checker display form"""

    legend = _("Content check")
    icon_css_class = 'fa fa-fw fa-check-square-o'

    fields = field.Fields(Interface)


@viewlet_config(name='content-check',
                context=Interface, layer=IAdminLayer, view=ContentCheckerForm,
                manager=IWidgetsSuffixViewletsManager, weight=1)
class ContentCheckerWidgetsSuffix(Viewlet):
    """Content checker widgets suffix"""

    def render(self):
        output = []
        registry = self.request.registry
        translate = self.request.localizer.translate
        for name, checker in sorted(registry.getAdapters((self.context, ), IContentChecker),
                                    key=lambda x: x[1].weight):
            header = '<strong>{0}</strong>'.format(translate(checker.label))
            checker_output = checker.get_check_output()
            if checker_output:
                output.append(translate(_('{0}:')).format(header))
                output.append(checker_output)
        if not output:
            translate = self.request.localizer.translate
            output.append(translate(_("No checker available. This content is clean!")))
        return '\n'.join(output)
