#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces

# import packages
from zope.interface import Interface, Attribute

from pyams_content import _


VALUE_OK = '<span class="text-success">OK</span>'
MISSING_VALUE = _(' - {field}: <span class="text-danger">no value</span>')
MISSING_LANG_VALUE = _(' - {field} ({lang}): <span class="text-danger">no value</span>')
ERROR_VALUE = _(' - {field}: <span class="text-danger">{message}</span>')


class IContentChecker(Interface):
    """Content checker interface"""

    label = Attribute("Adapter label")
    weight = Attribute("Adapter weight")

    def get_check_output(self, request=None):
        """Get context check as HTML output"""

    def inner_check(self, request):
        """Get unformatted field by field error messages"""
