#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.features.checker.interfaces import VALUE_OK

# import packages
from pyams_utils.adapter import ContextAdapter
from pyams_utils.request import check_request


class BaseContentChecker(ContextAdapter):
    """Base content checker"""

    label = None
    weight = 1
    sep = '<br />'

    def get_check_output(self, request=None):
        if request is None:
            request = check_request()
        translate = request.localizer.translate
        output = self.inner_check(request)
        if output:
            output = [self.sep.join(output)]
            output.insert(0, '<div class="padding-left-20">')
            output.append('</div>')
        else:
            output.append(translate(VALUE_OK) + '<br />')
        return '\n'.join(output)

    def inner_check(self, request):
        return []
