#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form import field

from pyams_content.features.alert import IAlertManagerInfo
from pyams_content.interfaces import MANAGE_SITE_ROOT_PERMISSION
from pyams_content.root import ISiteRoot
from pyams_form.form import AJAXAddForm, ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.event import get_json_table_row_refresh_event
from pyams_skin.interfaces.viewlet import IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuItem
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_utils.traversing import get_parent
from pyams_utils.url import absolute_url
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminDialogAddForm, AdminDialogEditForm


__docformat__ = 'restructuredtext'

from pyams_content import _
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer


@viewlet_config(name='alerts-manager.menu',
                context=ISiteRoot, layer=IAdminLayer,
                manager=IPropertiesMenu, weight=760,
                permission=MANAGE_SITE_ROOT_PERMISSION)
class AlertsManagerMenu(MenuItem):
    """Alerts manager menu"""

    label = _("Alerts settings...")
    icon_class = 'fa-warning'
    url = 'alerts-manager.html'
    modal_target = True


@pagelet_config(name='alerts-manager.html',
                context=ISiteRoot, layer=IPyAMSLayer,
                permission=MANAGE_SITE_ROOT_PERMISSION)
@ajax_config(name='alerts-manager.json',
             context=ISiteRoot, layer=IPyAMSLayer)
class AlertsManagerEditForm(AdminDialogEditForm):
    """Alerts manager edit form"""

    prefix = 'alerts_manager.'

    legend = _("Alerts settings")
    dialog_class = 'modal-large'

    fields = field.Fields(IAlertManagerInfo)

    edit_permission = MANAGE_SITE_ROOT_PERMISSION

    def getContent(self):
        return IAlertManagerInfo(self.context)
