#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from persistent import Persistent
from zope.component import getUtilitiesFor
from zope.interface import implementer
from zope.schema.fieldproperty import FieldProperty
from zope.schema.vocabulary import SimpleVocabulary, SimpleTerm

from pyams_content import _
from pyams_content.component.video import external_video_settings_factory
from pyams_content.component.video.interfaces import IExternalVideo, IExternalVideoProvider, IExternalVideoSettings
from pyams_content.component.video.provider.interfaces import ICustomVideoSettings
from pyams_content.features.checker import BaseContentChecker
from pyams_content.features.checker.interfaces import IContentChecker
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import utility_config
from pyams_utils.request import check_request
from pyams_utils.vocabulary import vocabulary_config


@vocabulary_config(name='PyAMS video providers')
class VideoProvidersVocabulary(SimpleVocabulary):
    """Video providers vocabulary"""

    interface = IExternalVideoProvider

    def __init__(self, context):
        request = check_request()
        translate = request.localizer.translate
        utils = sorted(getUtilitiesFor(self.interface, context),
                       key=lambda x: getattr(x[1], 'weight', 0))
        terms = [SimpleTerm(name, title=translate(getattr(util, 'label', name))) for name, util in utils]
        super(VideoProvidersVocabulary, self).__init__(terms)


#
# Custom video provider settings
#

@implementer(ICustomVideoSettings)
class CustomVideoSettings(Persistent):
    """Custom video provider settings"""

    integration_code = FieldProperty(ICustomVideoSettings['integration_code'])


@utility_config(name='custom', provides=IExternalVideoProvider)
class CustomVideoProvider(object):
    """Custom video provider"""

    label = _("Other provider")
    weight = 99

    settings_interface = ICustomVideoSettings


@adapter_config(context=IExternalVideo, provides=ICustomVideoSettings)
def custom_video_settings_factory(context):
    """Custom video settings factory"""
    if context.provider_name != 'custom':
        return None
    return external_video_settings_factory(context)


@adapter_config(context=CustomVideoProvider, provides=IExternalVideoSettings)
def custom_video_provider_settings_factory(context):
    """Custom video provider settings factory"""
    return CustomVideoSettings()


@adapter_config(context=ICustomVideoSettings, provides=IContentChecker)
class CustomVideoSettingsContentChecker(BaseContentChecker):
    """Custom video settings content checker"""

    label = _("Custom video settings")

    def inner_check(self, request):
        return []
