#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.annotation import IAttributeAnnotatable
from zope.contentprovider.interfaces import IContentProvider
from zope.interface import Interface, Attribute
from zope.schema import Choice, TextLine

from pyams_content import _
from pyams_content.component.paragraph.interfaces import IBaseParagraph
from pyams_i18n.schema import I18nTextField, I18nTextLineField


class IExternalVideoSettings(Interface):
    """External video settings"""

    video_id = Attribute("Video ID")


class IExternalVideoProvider(Interface):
    """External video provider"""

    label = Attribute("Video provider label")
    weight = Attribute("Video provider weight (used for ordering)")
    settings_interface = Attribute("Video provider settings interface")


class IExternalVideo(IAttributeAnnotatable):
    """Base interface for external video integration"""

    author = TextLine(title=_("Author"),
                      description=_("Name of document's author"),
                      required=True)

    description = I18nTextField(title=_("Associated text"),
                                description=_("Video description displayed by front-office template"),
                                required=False)

    provider_name = Choice(title=_("Video provider"),
                           description=_("Name of external platform providing selected video"),
                           required=False,
                           vocabulary="PyAMS video providers")

    def get_provider(self):
        """Get external video provider utility"""

    settings = Attribute("Video settings")


EXTERNAL_VIDEO_PARAGRAPH_TYPE = 'External video'
EXTERNAL_VIDEO_PARAGRAPH_NAME = _("External video")
EXTERNAL_VIDEO_PARAGRAPH_RENDERERS = 'PyAMS.video.renderers'


class IExternalVideoParagraph(IExternalVideo, IBaseParagraph):
    """External video paragraph"""

    title = I18nTextLineField(title=_("Legend"),
                              required=False)

    renderer = Choice(title=_("Video template"),
                      description=_("Presentation template used for this video"),
                      vocabulary=EXTERNAL_VIDEO_PARAGRAPH_RENDERERS,
                      default='default')


class IExternalVideoRenderer(IContentProvider):
    """External video renderer"""
